"use strict";
const { isPlainObject: _isPlainObject } = require('is-plain-object');
function isBoolean(value) {
    return typeof value === 'boolean' || value instanceof Boolean;
}
function isFunction(value) {
    return typeof value === 'function' || value instanceof Function;
}
function isNullish(value) {
    return value == null;
}
function isNumber(value) {
    return typeof value === 'number' || value instanceof Number;
}
function isObject(value) {
    return value !== null && typeof value === 'object';
}
function isRegExp(value) {
    return value instanceof RegExp;
}
function isString(value) {
    return typeof value === 'string' || value instanceof String;
}
function isPlainObject(value) {
    return _isPlainObject(value);
}
function assert(value, message = undefined) {
    if (message) {
        console.assert(value, message);
    }
    else {
        console.assert(value);
    }
}
function assertFunction(value) {
    console.assert(isFunction(value), `"${value}" must be a function`);
}
function assertNumber(value) {
    console.assert(isNumber(value), `"${value}" must be a number`);
}
function assertString(value) {
    console.assert(isString(value), `"${value}" must be a string`);
}
module.exports = {
    isBoolean,
    isFunction,
    isNullish,
    isNumber,
    isObject,
    isRegExp,
    isString,
    isPlainObject,
    assert,
    assertFunction,
    assertNumber,
    assertString,
};
