export function isBoolean(value: unknown): value is boolean;
export function isFunction(value: unknown): value is Function;
export function isNullish(value: unknown): value is null | undefined;
export function isNumber(value: unknown): value is number;
export function isObject(value: unknown): value is object;
export function isRegExp(value: unknown): value is RegExp;
export function isString(value: unknown): value is string;
export function isPlainObject(value: unknown): value is Record<string, unknown>;
export function assert(value: unknown, message?: string | undefined): asserts value;
export function assertFunction(value: unknown): asserts value is Function;
export function assertNumber(value: unknown): asserts value is number;
export function assertString(value: unknown): asserts value is string;
