"use strict";
const valueParser = require('postcss-value-parser');
const { assert } = require('./validateTypes');
const rangeOperators = new Set(['>=', '<=', '>', '<', '=']);
function isRangeContextName(name) {
    return /^(?!--)\D/.test(name) || /^--./.test(name);
}
module.exports = function rangeContextNodeParser(node) {
    let nameNode;
    const valueNodes = [];
    valueParser(node.value).walk((valueNode) => {
        if (valueNode.type !== 'word')
            return;
        if (rangeOperators.has(valueNode.value))
            return;
        if (nameNode == null && isRangeContextName(valueNode.value)) {
            nameNode = valueNode;
            return;
        }
        valueNodes.push(valueNode);
    });
    assert(nameNode);
    return {
        name: {
            value: nameNode.value,
            sourceIndex: node.sourceIndex + nameNode.sourceIndex,
        },
        values: valueNodes.map((valueNode) => ({
            value: valueNode.value,
            sourceIndex: node.sourceIndex + valueNode.sourceIndex,
        })),
    };
};
