"use strict";
const { createPlugin } = require('stylelint');
const ruleMessages = require('stylelint/lib/utils/ruleMessages');
const selectorCombinatorSpaceChecker = require('stylelint/lib/rules/selectorCombinatorSpaceChecker');
const validateOptions = require('stylelint/lib/utils/validateOptions');
const whitespaceChecker = require('stylelint/lib/utils/whitespaceChecker');
const ruleName = 'stylistic/selector-combinator-space-before';
const messages = ruleMessages(ruleName, {
    expectedBefore: (combinator) => `Expected single space before "${combinator}"`,
    rejectedBefore: (combinator) => `Unexpected whitespace before "${combinator}"`,
});
const meta = {
    url: 'https://github.com/elirasza/stylelint-stylistic/tree/main/lib/rules/selector-combinator-space-before',
    fixable: true,
};
const rule = (primary, _secondaryOptions, context) => {
    const checker = whitespaceChecker('space', primary, messages);
    return (root, result) => {
        const validOptions = validateOptions(result, ruleName, {
            actual: primary,
            possible: ['always', 'never'],
        });
        if (!validOptions) {
            return;
        }
        selectorCombinatorSpaceChecker({
            root,
            result,
            locationChecker: checker.before,
            locationType: 'before',
            checkedRuleName: ruleName,
            fix: context.fix
                ? (combinator) => {
                    if (primary === 'always') {
                        combinator.spaces.before = ' ';
                        return true;
                    }
                    if (primary === 'never') {
                        combinator.spaces.before = '';
                        return true;
                    }
                    return false;
                }
                : null,
        });
    };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
module.exports = { messages, meta, plugin: createPlugin(ruleName, rule), rule, ruleName };
