"use strict";
const { createPlugin } = require('stylelint');
const report = require('stylelint/lib/utils/report');
const ruleMessages = require('stylelint/lib/utils/ruleMessages');
const validateOptions = require('stylelint/lib/utils/validateOptions');
const ruleName = 'stylistic/no-missing-end-of-source-newline';
const messages = ruleMessages(ruleName, {
    rejected: 'Unexpected missing end-of-source newline',
});
const meta = {
    url: 'https://github.com/elirasza/stylelint-stylistic/tree/main/lib/rules/no-missing-end-of-source-newline',
    fixable: true,
};
const rule = (primary, _secondaryOptions, context) => (root, result) => {
    const validOptions = validateOptions(result, ruleName, { actual: primary });
    if (!validOptions) {
        return;
    }
    if (root.source == null) {
        throw new Error('The root node must have a source property');
    }
    if (root.source.inline || root.source.lang === 'object-literal') {
        return;
    }
    const rootString = context.fix ? root.toString() : root.source.input.css;
    if (!rootString.trim() || rootString.endsWith('\n')) {
        return;
    }
    if (context.fix) {
        root.raws.after = context.newline;
        return;
    }
    report({
        message: messages.rejected,
        node: root,
        index: rootString.length - 1,
        result,
        ruleName,
    });
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
module.exports = { messages, meta, plugin: createPlugin(ruleName, rule), rule, ruleName };
