"use strict";
const { createPlugin } = require('stylelint');
const report = require('stylelint/lib/utils/report');
const ruleMessages = require('stylelint/lib/utils/ruleMessages');
const validateOptions = require('stylelint/lib/utils/validateOptions');
const ruleName = 'stylistic/no-empty-first-line';
const noEmptyFirstLineTest = /^\s*[\r\n]/;
const messages = ruleMessages(ruleName, {
    rejected: 'Unexpected empty line',
});
const meta = {
    url: 'https://github.com/elirasza/stylelint-stylistic/tree/main/lib/rules/no-empty-first-line',
    fixable: true,
};
const rule = (primary, _secondaryOptions, context) => (root, result) => {
    const validOptions = validateOptions(result, ruleName, { actual: primary });
    if (!validOptions || root.source.inline || root.source.lang === 'object-literal') {
        return;
    }
    const rootString = context.fix ? root.toString() : (root.source && root.source.input.css) || '';
    if (!rootString.trim()) {
        return;
    }
    if (noEmptyFirstLineTest.test(rootString)) {
        if (context.fix) {
            if (root.first == null) {
                throw new Error('The root node must have the first node.');
            }
            if (root.first.raws.before == null) {
                throw new Error('The first node must have spaces before.');
            }
            root.first.raws.before = root.first.raws.before.trimStart();
            return;
        }
        report({
            message: messages.rejected,
            node: root,
            result,
            ruleName,
        });
    }
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
module.exports = { messages, meta, plugin: createPlugin(ruleName, rule), rule, ruleName };
