"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveGlobUrlFactory = void 0;
function resolveGlobUrlFactory(glob, path) {
    return (url, includePaths = []) => {
        const filePaths = new Set();
        if (glob.hasMagic(url)) {
            includePaths.forEach((includePath) => {
                const globPaths = glob.sync(url, { cwd: includePath });
                globPaths.forEach((relativePath) => {
                    filePaths.add(path.resolve(includePath, relativePath)
                        // This fixes a problem with importing absolute paths on windows.
                        .split(`\\`).join(`/`));
                });
            });
            return [...filePaths];
        }
        return null;
    };
}
exports.resolveGlobUrlFactory = resolveGlobUrlFactory;
//# sourceMappingURL=resolve-glob-url.js.map