"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseSelectorFiltersFactory = void 0;
function parseSelectorFiltersFactory(processRawSelectorFilters, splitSelectorFilter) {
    return (url) => {
        const filterDivider = /[\s]+from[\s]+(?!.*from)/;
        if (!filterDivider.test(url)) {
            return [];
        }
        const selectorFiltersMatch = url
            .split(filterDivider)[0]
            .match(/{([\s\S]*)}/);
        if (!selectorFiltersMatch) {
            return [];
        }
        const rawSelectorFilters = selectorFiltersMatch[1].split(`,`)
            .map((x) => splitSelectorFilter(x.trim()));
        return processRawSelectorFilters(rawSelectorFilters);
    };
}
exports.parseSelectorFiltersFactory = parseSelectorFiltersFactory;
//# sourceMappingURL=parse-selector-filters.js.map