"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseNodeFiltersFactory = void 0;
function parseNodeFiltersFactory() {
    return (url) => {
        const filterDivider = /[\s]+from[\s]+(?!.*from)/;
        if (!filterDivider.test(url)) {
            return [];
        }
        const nodeFiltersMatch = url
            .split(filterDivider)[0]
            .replace(/{.*?\/.*?\/.*?}/, ``)
            .match(/\[([\s\S]*)\]/);
        if (!nodeFiltersMatch) {
            return [];
        }
        return nodeFiltersMatch[1].split(`,`)
            .map((x) => x.trim())
            .filter((x) => x.length);
    };
}
exports.parseNodeFiltersFactory = parseNodeFiltersFactory;
//# sourceMappingURL=parse-node-filters.js.map