"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildIncludePathsFactory = void 0;
function buildIncludePathsFactory(path) {
    return (nodeSassIncludePaths, previouslyResolvedPath) => {
        const includePaths = [];
        if (path.isAbsolute(previouslyResolvedPath)) {
            includePaths.push(path.dirname(previouslyResolvedPath));
        }
        return [...new Set([...includePaths, ...nodeSassIncludePaths.split(path.delimiter)])];
    };
}
exports.buildIncludePathsFactory = buildIncludePathsFactory;
//# sourceMappingURL=build-include-paths.js.map