"use strict";
const postcss = require("postcss");
const filterSelector = require("./filter-selector");
const const_1 = require("../const");
module.exports = function postcssSelectorExtract(filters = [], preserveLines = false) {
    return postcss.plugin(`postcss-extract-selectors`, () => (nodes) => {
        // We have to force `any` type, because postcss type
        // definitions seem to be outdated.
        nodes.walkRules((rule) => {
            const ruleSelectors = rule.selector
                .split(`,`)
                .map((ruleSelector) => ruleSelector.replace(/(\r\n|\n|\r)/gm, ``).trim())
                .map((ruleSelector) => filterSelector({
                ruleSelector,
                ruleParentSelectors: rule.parent.selector ? rule.parent.selector.split(`,`) : [],
                filters,
            }))
                .filter((ruleSelector) => ruleSelector.length);
            if (ruleSelectors.length) {
                rule.selector = ruleSelectors.join(`,`);
            }
            else {
                if (preserveLines) {
                    const ruleLines = rule.toString().split(/\r\n|\r|\n/).length;
                    rule.cloneBefore({
                        type: `comment`,
                        text: `${const_1.PRESERVE_LINES_START}${'\n'.repeat(ruleLines - 1)}${const_1.PRESERVE_LINES_END}`,
                        raws: Object.assign(rule.raws, { left: ' ', right: ' ' }),
                    });
                }
                rule.remove();
            }
        });
        // Remove empty @ rules.
        nodes.walkAtRules((rule) => {
            if (rule.nodes && !rule.nodes.length) {
                rule.remove();
            }
        });
    });
};
//# sourceMappingURL=postcss-selector-extract.js.map