"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const postcss = require("postcss");
const postcssSelectorExtract = require("./lib/postcss-selector-extract");
const const_1 = require("./const");
/**
 * Synchronously extract and replace CSS selectors from a string.
 */
exports.processSync = ({ css, filters, postcssSyntax, preserveLines, }) => postcss(postcssSelectorExtract(filters, preserveLines))
    .process(css, { syntax: postcssSyntax }).css
    .replace(new RegExp(`\\/\\* ${const_1.PRESERVE_LINES_START}|${const_1.PRESERVE_LINES_END} \\*\\/`, `g`), ``);
/**
 * Asynchronously extract and replace CSS selectors from a string.
 */
exports.process = (options) => new Promise((resolve) => {
    const result = exports.processSync(options);
    resolve(result);
});
/**
 * cssSelectorExtract
 */
exports.default = {
    process: exports.process,
    processSync: exports.processSync,
};
//# sourceMappingURL=index.js.map