"use strict";
const change_case_1 = require("change-case");
const postcss = require("postcss");
const extractNodeRecursively = require("./extract-node-recursively");
const filterDefinitions = require("./filter-definitions");
const const_1 = require("../const");
module.exports = function postcssNodeExtract(filterNames, customFilters, preserveLines = false) {
    const filterNamesArray = Array.isArray(filterNames) ? filterNames : [filterNames];
    Object.assign(filterDefinitions, customFilters);
    return postcss.plugin(`postcss-node-extract`, () => (nodes) => {
        nodes.walk((rule) => {
            let filterRule = false;
            filterNamesArray.some((filterName) => {
                const filterNameCamelCase = change_case_1.camelCase(filterName);
                filterRule = extractNodeRecursively(rule, filterDefinitions[filterNameCamelCase]);
                return filterRule;
            });
            if (!filterRule) {
                if (preserveLines) {
                    const ruleLines = rule.toString().split(/\r\n|\r|\n/).length;
                    rule.cloneBefore({
                        type: `comment`,
                        text: `${const_1.PRESERVE_LINES_START}${'\n'.repeat(ruleLines - 1)}${const_1.PRESERVE_LINES_END}`,
                        raws: Object.assign(rule.raws, { left: ' ', right: ' ' }),
                    });
                }
                rule.remove();
            }
        });
    });
};
//# sourceMappingURL=postcss-node-extract.js.map