"use strict";
const nodeMatchesFilter = require("./node-matches-filter");
module.exports = function extractNodeRecursively(node, filterGroups) {
    if (node.parent && node.parent.type !== `root`) {
        return extractNodeRecursively(node.parent, filterGroups);
    }
    let extractNode = false;
    filterGroups.some((filterGroup) => {
        extractNode = filterGroup.filter((filter) => !nodeMatchesFilter(node, filter)).length === 0;
        return extractNode;
    });
    return extractNode;
};
//# sourceMappingURL=extract-node-recursively.js.map