"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const postcss = require("postcss");
const postcssNodeExtract = require("./lib/postcss-node-extract");
const const_1 = require("./const");
/**
 * Synchronously extract nodes from a string.
 */
exports.processSync = ({ css, filters, customFilters, postcssSyntax, preserveLines, }) => postcss(postcssNodeExtract(filters, customFilters, preserveLines))
    .process(css, { syntax: postcssSyntax }).css
    .replace(new RegExp(`\\/\\* ${const_1.PRESERVE_LINES_START}|${const_1.PRESERVE_LINES_END} \\*\\/`, `g`), ``);
/**
 * Asynchronously extract nodes from a string.
 */
exports.process = (options) => new Promise((resolve) => {
    const result = exports.processSync(options);
    resolve(result);
});
/**
 * cssNodeExtract
 */
exports.default = {
    process: exports.process,
    processSync: exports.processSync,
};
//# sourceMappingURL=index.js.map