/**
 * @file
 * Search utilities.
 *
 */

(function ($, Drupal) {
  Drupal.behaviors.emorySearchToggle = {
    attach: function (context, settings) {
      $('.search-block-form', context).hide();
      $('.emory-search-button', context).on('click', function () {
        $('.search-block-form', context).toggle();
        $('.emory-search', context).toggleClass('bg-emory-gold');
        $('.emory-search-button', context).toggleClass('link-emory-white link-emory-yellow link-opacity-75-hover');
      });
      $('.btn-emory-search').on('click', function(event) {
        $(this).closest('form').submit();
      });
      $('.form-search', context).on('keypress', function (e) {
        if (e.which === 13) {
          e.preventDefault();
          $(this).closest('form').submit();
        }
      });
      $('#collapseSidebar').on('show.bs.collapse', function () {
        $('#mainContent').toggleClass('col-md-7 col-md-12 pe-md-0 pe-sm-4 pe-md-6 pe-lg-6 pe-xl-7 pe-xxl-8');
        $('.btn-collapse-sidebar i').toggleClass('fa-chevron-up fa-chevron-down');
      });
      $('#collapseSidebar').on('hide.bs.collapse', function () {
        $('.btn-collapse-sidebar i').toggleClass('fa-chevron-up fa-chevron-down');
        setTimeout(() => {
          $('#mainContent').toggleClass('col-md-7 col-md-12 pe-md-0 pe-sm-4 pe-md-6 pe-lg-6 pe-xl-7 pe-xxl-8');
        }, 300);
      });
    },
  };
})(jQuery, Drupal);
