<?php

namespace Drupal\emory_isss_social_block\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for configuring the Social Block.
 */
class SocialBlockConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['emory_isss_social_block.social_block_config'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'social_block_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('emory_isss_social_block.social_block_config');

    $form['description'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Description'),
      '#allowed_formats' => ['restricted_html'],
      '#default_value' => $config->get('description.value'),
    ];
    $form['instagram_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Instagram ID'),
      '#default_value' => $config->get('instagram_id'),
    ];
    $form['instagram_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Instagram URL'),
      '#default_value' => $config->get('instagram_url'),
    ];
    $form['facebook_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Facebook URL'),
      '#default_value' => $config->get('facebook_url'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('emory_isss_social_block.social_block_config')
      ->set('description', $form_state->getValue('description.value'))
      ->set('instagram_id', $form_state->getValue('instagram_id'))
      ->set('instagram_url', $form_state->getValue('instagram_url'))
      ->set('facebook_url', $form_state->getValue('facebook_url'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
