<?php

namespace Drupal\emory_isss_announcement\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for configuring the Announcement.
 */
class AnnouncementConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['emory_isss_announcement.announcement_config'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'announcement_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('emory_isss_announcement.announcement_config');

    $form['announcement'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Announcement'),
      '#default_value' => $config->get('announcement'),
    ];
    $form['appointment'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Appointment'),
      '#default_value' => $config->get('appointment'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('emory_isss_announcement.announcement_config')
      ->set('announcement', $form_state->getValue('announcement'))
      ->set('appointment', $form_state->getValue('appointment'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
