# emoryisss project

This guide provides instructions for setting up and updating
Emory ISSS project in a local development environment.

## Requirements

- [Git](https://git-scm.com/)
- [Composer](https://getcomposer.org/)
- [Lando](https://docs.lando.dev/getting-started/installation.html)

## Install the project

### Clone the Project (First Time)

1. Open a terminal window.

2. Clone the project repository.

    ```bash
    git clone git@github.com:trimosolutions/emory-isss.git
    ```

3. Navigate to the project directory.

    ```bash
    cd emory-isss
    ```

4. If you are using lando:

    ```bash
    lando start
    ```

5. Install dependencies using Composer.

    ```bash
    lando composer install
    ```

6. Import config changes:

    ```bash
    lando drush cim -y
    ```

7. To mount a database:

   ```bash
   lando drush sql-drop
   lando db-import <databaseName>
   ```

8. Access the Drupal site in your web browser.

   [https://emory-isss.lndo.site](https://emory-isss.lndo.site)

### 2. Update the Main Branch

1. Open a terminal window.

2. Navigate to the project directory.

    ```bash
    cd emory-isss
    ```

3. Start the project with Lando:

    ```bash
    lando start
    ```

4. Pull the latest changes from the main branch:

    ```bash
    git checkout main && git pull origin main
    ```

5. Install or update Composer dependencies:

    ```bash
    lando composer install
    ```

6. Update database changes:

    ```bash
    lando drush updb -y
    ```

7. Import config changes:

    ```bash
    lando drush cim -y
    ```

8. Clear the cache.

    ```bash
    lando drush cr
    ```

9. Access the Drupal site in your web browser.

   [https://emory-isss.lndo.site](https://emory-isss.lndo.site)

## Theme setup

1. Go to theme folder [Emory ISSS theme](web/themes/custom/emoryisss/README.md)

